#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=183099 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (158999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159240, 'Database Backup [database_backup_2024-12-19-00-02-03-v3-1-6.zip]', '2024-12-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (159999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-19 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-19 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-19 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160021, 'Database Backup [database_backup_2024-12-20-00-00-02-v3-1-6.zip]', '2024-12-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160709, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160710, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160810, 'Database Backup [database_backup_2024-12-21-00-05-02-v3-1-6.zip]', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161615, 'Database Backup [database_backup_2024-12-22-00-04-02-v3-1-6.zip]', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162402, 'Database Backup [database_backup_2024-12-23-00-03-03-v3-1-6.zip]', '2024-12-23 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log`