#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=353470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330760, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330857, 'Database Backup [database_backup_2025-07-17-00-03-03-v3-3-1.zip]', '2025-07-17 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331506, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331603, 'Database Backup [database_backup_2025-07-18-00-02-03-v3-3-1.zip]', '2025-07-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332252, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332253, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332254, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332255, 'Invoice Status Updated [Invoice Number: INV-178/07/2025, From: Unpaid To: Overdue]', '2025-07-18 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332256, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332353, 'Database Backup [database_backup_2025-07-19-00-03-02-v3-3-1.zip]', '2025-07-19 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333002, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-19 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333099, 'Database Backup [database_backup_2025-07-20-00-00-03-v3-3-1.zip]', '2025-07-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333754, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-07-20 21:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333851, 'Database Backup [database_backup_2025-07-21-00-01-03-v3-3-1.zip]', '2025-07-21 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334506, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-21 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334507, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-21 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334508, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-21 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334509, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-21 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334606, 'Database Backup [database_backup_2025-07-22-00-02-02-v3-3-1.zip]', '2025-07-22 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (334674, 'Failed to connect to IMAP auto