#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=142631 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118800, 'Database Backup [database_backup_2024-10-29-00-04-03-v3-1-6.zip]', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118972, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.138]', '2024-10-29 05:15:50', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119591, 'Database Backup [database_backup_2024-10-30-00-01-03-v3-1-6.zip]', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120282, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120283, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120386, 'Database Backup [database_backup_2024-10-31-00-04-02-v3-1-6.zip]', '2024-10-31 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121176, 'Database Backup [database_backup_2024-11-01-00-04-01-v3-1-6.zip]', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121975, 'Database Backup [database_backup_2024-11-02-00-04-03-v3-1-6.zip]', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tb