#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=205467 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181495, 'Database Backup [database_backup_2025-01-16-00-04-02-v3-1-6.zip]', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182183, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-16 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182184, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182299, 'Database Backup [database_backup_2025-01-17-00-02-03-v3-1-6.zip]', '2025-01-17 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182999, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183099, 'Database Backup [database_backup_2025-01-18-00-01-02-v3-1-6.zip]', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183886, 'Database Backup [database_backup_2025-01-19-00-02-02-v3-1-6.zip]', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184580, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-19 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184581, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184684, 'Database Backup [database_backup_2025-01-20-00-02-02-v3-1-6.zip]', '2025-01-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `dat