#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=333099 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 05:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 09:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 09:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 09:49:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:09:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:47:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:47:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 10:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 10:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:10:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 11:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:13:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:19:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:25:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:31:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:43:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:49:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 12:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 12:54:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:28:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:33:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:39:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 13:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 13:56:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:01:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:12:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:18:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:47:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:53:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 14:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:04:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:10:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:22:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:50:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 15:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 15:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:19:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:36:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:42:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 16:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 16:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:52:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 17:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:09:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:25:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 18:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 18:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:32:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:37:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:43:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:54:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 19:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 19:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:39:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 20:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:18:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:24:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:35:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:41:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:52:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 21:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 21:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:16:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:34:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 22:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 22:56:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:01:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:36:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:41:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:47:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-20 23:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-20 23:58:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307567, 'Database Backup [database_backup_2025-06-21-00-04-07-v3-1-6.zip]', '2025-06-21 00:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:46:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 00:58:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:10:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:16:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:21:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:33:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:43:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 01:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 01:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:33:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 02:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 02:56:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:32:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:43:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:49:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 03:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:06:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:29:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:45:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 04:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:08:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:24:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:30:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:47:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:53:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 05:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:15:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:44:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:50:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 06:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:01:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:12:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:41:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:53:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 07:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:22:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 08:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:31:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 09:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:17:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (307999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:23:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:28:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:45:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 10:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:01:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:07:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:13:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:30:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 11:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 11:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:05:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:28:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:51:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 12:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:09:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:19:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:31:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:37:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 13:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:06:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:12:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:39:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 14:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:13:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:53:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 15:59:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:26:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:43:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:49:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 16:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:00:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:06:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:34:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:40:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 17:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:04:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:38:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:44:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:32:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 19:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 19:55:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:42:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 20:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:18:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:40:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 21:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 21:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:25:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:37:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:49:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 22:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:24:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-21 23:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-21 23:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308572, 'Database Backup [database_backup_2025-06-22-00-03-05-v3-1-6.zip]', '2025-06-22 00:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:03:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:09:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:20:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 00:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 00:59:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:11:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:23:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:46:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:52:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 01:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:40:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:45:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 02:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:25:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:31:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:42:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 03:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:17:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:00:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:06:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:40:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:46:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:58:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:10:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:16:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:22:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:27:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:24:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:41:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:47:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:52:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:03:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:32:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:12:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:24:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:29:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:56:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:13:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:19:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:25:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:15:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:32:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:50:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:02:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:08:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:13:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:25:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:11:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:27:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:33:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:44:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:50:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:01:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:12:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:23:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:29:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:14:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:36:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:05:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:20:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309577, 'Database Backup [database_backup_2025-06-23-00-04-05-v3-1-6.zip]', '2025-06-23 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:14:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:48:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:44:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:12:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:18:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:41:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:32:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:15:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310574, 'Database Backup [database_backup_2025-06-24-00-00-09-v3-1-6.zip]', '2025-06-24 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:39:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:50:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:35:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:30:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:48:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:34:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:45:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:51:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:56:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:01:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:06:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:28:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:34:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:46:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:57:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:20:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:31:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:53:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:56:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:15:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:20:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:48:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:16:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:27:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:33:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:38:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:44:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:55:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:12:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:17:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:34:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311557, 'Failed to