#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=267534 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243681, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243793, 'Database Backup [database_backup_2025-04-03-00-03-03-v3-1-6.zip]', '2025-04-03 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244514, 'Invoice Status Updated [Invoice Number: INV-171/03/2025, From: Unpaid To: Overdue]', '2025-04-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244515, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Overdue Notice]', '2025-04-03 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244516, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Overdue Notice]', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244622, 'Database Backup [database_backup_2025-04-04-00-02-05-v3-1-6.zip]', '2025-04-04 00:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245334, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-04 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245335, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-04 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245447, 'Database Backup [database_backup_2025-04-05-00-04-03-v3-1-6.zip]', '2025-04-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246156, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-05 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-05 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-05 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-05 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246256, 'Database Backup [database_backup_2025-04-06-00-00-07-v3-1-6.zip]', '2025-04-06 00:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246968, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Overdue Notice]', '2025-04-06 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246969, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Overdue Notice]', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247072, 'Database Backup [database_backup_2025-04-07-00-00-08-v3-1-6.zip]', '2025-04-07 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247520, 'Failed 