#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=137914 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 13:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113797, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.180]', '2024-10-22 17:26:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (113999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-22 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114014, 'Database Backup [database_backup_2024-10-23-00-00-04-v3-1-6.zip]', '2024-10-23 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-23 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114813, 'Database Backup [database_backup_2024-10-24-00-05-02-v3-1-6.zip]', '2024-10-24 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114985, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-10-24 05:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (114999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115505, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-24 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115506, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-24 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115549, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-10-24 22:16:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115610, 'Database Backup [database_backup_2024-10-25-00-00-03-v3-1-6.zip]', '2024-10-25 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115974, 'Client Deleted [ID: 64]', '2024-10-25 10:57:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (115999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-25 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-25 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-25 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116410, 'Database Backup [database_backup_2024-10-26-00-01-02-v3-1-6.zip]', '2024-10-26 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117200, 'Database Backup [database_backup_2024-10-27-00-02-01-v3-1-6.zip]', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `sta