#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=66293 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44226, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-25 14:33:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44233, 'Invoice Status Updated [Invoice Number: INV-160/07/2024, From: Unpaid To: Paid]', '2024-07-25 14:44:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44234, 'Payment Recorded [ID:106, Invoice Number: INV-160/07/2024, Total: $1,500.00]', '2024-07-25 14:44:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44235, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-25 14:44:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44518, 'Database Backup [database_backup_2024-07-26-00-00-04-v3-1-1.zip]', '2024-07-26 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44732, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-26 07:08:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45006, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-26 16:11:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45151, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-26 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45152, 'Invoice Status Updated [Invoice Number: INV-157/07/2024, From: Unpaid To: Overdue]', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45246, 'Database Backup [database_backup_2024-07-27-00-02-02-v3-1-1.zip]', '2024-07-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45568, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-27 10:44:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45875, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Overdue Notice]', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45969, 'Database Backup [database_backup_2024-07-28-00-00-04-v3-1-1.zip]', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46690, 'Database Backup [database_backup_2024-07-29-00-00-03-v3-1-1.zip]', '2024-07-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46997, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-29 10:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47145, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Forgot Password]', '2024-07-29 15:08:20', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47146, 'Password Reset Email sent [Email: livinglovelly@gmail.com, Is Staff Member: No, IP: 200.7.90.190]', '2024-07-29 15:08:20', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47324, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-29 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-29 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-29 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-29 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47418, 'Database Backup [database_backup_2024-07-30-00-02-02-v3-1-1.zip]', '2024-07-30 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47701, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-07-30 09:24:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (47999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48050, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Overdue Notice]', '2024-07-30 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48144, 'Database Backup [database_backup_2024-07-31-00-00-04-v3-1-1.zip]', '2024-07-31 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48316, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-07-31 05:43:22', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48350, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 200.7.90.167]', '2024-07-31 06:57:38', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48357, 'whiteboard Group Added [ID: 1]', '2024-07-31 07:09:40', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48361, 'New Web to Lead Form Added [Test]', '2024-07-31 07:14:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48362, 'Email sent to: clientportal@saylesstt.com Subject: Mentioned you', '2024-07-31 07:15:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48369, 'Mindmap Group Added [ID: 1]', '2024-07-31 07:25:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48370, 'Mindmap Deleted [ID:1]', '2024-07-31 07:25:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48371, 'Group Deleted [1]', '2024-07-31 07:25:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48372, 'Mindmap Group Added [ID: 2]', '2024-07-31 07:25:35', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48375, 'Failed to connect to IMAP auto importing tickets fo