#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=85156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61232, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-17 21:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61233, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-17 21:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61324, 'Database Backup [database_backup_2024-08-18-00-00-04-v3-1-6.zip]', '2024-08-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61928, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 200.7.90.165]', '2024-08-18 23:26:41', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61929, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 200.7.90.165]', '2024-08-18 23:26:55', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61930, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-18 23:27:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:11:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:11:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:11:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61934, 'Database Backup [database_backup_2024-08-19-12-11-22-v3-1-6.zip]', '2024-08-19 12:11:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61935, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-19 12:12:02', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62233, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-19 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-19 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-19 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-19 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (62999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63041, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-20 21:42:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63123, 'Database Backup [database_backup_2024-08-21-00-01-02-v3-1-6.zip]', '2024-08-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-08-21 09:33:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63794, 'Failed Login Attempt [Email: tishara.f@saylesstt.com, Is Staff Member: Yes, IP: 181.118.42.54]', '2024-08-21 20:51:57', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63798, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.54]', '2024-08-21 20:52:19', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63901, 'Database Backup [database_backup_2024-08-22-00-04-02-v3-1-6.zip]', '2024-08-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (63999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-08-22 10:18:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64452, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.54]', '2024-08-22 16:52:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64591, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-22 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-22 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-22 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-22 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64697, 'Database Backup [database_backup_2024-08-23-00-03-02-v3-1-6.zip]', '2024-08-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descri