#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=224097 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (201999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 20:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202155, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-10 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-10 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-10 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202258, 'Database Backup [database_backup_2025-02-11-00-04-02-v3-1-6.zip]', '2025-02-11 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-11 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (202999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-11 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203064, 'Database Backup [database_backup_2025-02-12-00-03-02-v3-1-6.zip]', '2025-02-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203758, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-12 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203759, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-12 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-12 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-12 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-12 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203859, 'Database Backup [database_backup_2025-02-13-00-00-06-v3-1-6.zip]', '2025-02-13 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (203999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204553, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-13 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-13 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-13 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-13 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204662, 'Database Backup [database_backup_2025-02-14-00-00-03-v3-1-6.zip]', '2025-02-14 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (204999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:44:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:44:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-14 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205467, 'Database Backup [database_backup_2025-02-15-00-04-03-v3-1-6.zip]', '2025-02-15 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (205999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-15 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (206026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-15 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) 